﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Collections.Generic;
using GE.World.Entities;
using Microsoft.Xna.Framework;

namespace GE.Manager
{
    /// <summary>
    /// Create, store, activate and handle a collection of explosion entities
    /// </summary>
    class ExplosionManager
    {
        /// <summary>
        /// Singleton instance
        /// </summary>
        static ExplosionManager _instance = null;

        /// <summary>
        /// Number of explosion the manager handles
        /// </summary>
        int _iExplosionCount;

        /// <summary>
        /// List of reference to the explosion entities
        /// </summary>
        List<ExplosionEntity> _listExplosionEntity;

        /// <summary>
        /// Constructor
        /// </summary>
        private ExplosionManager()
        {
            _iExplosionCount = 0;
            _listExplosionEntity = new List<ExplosionEntity>();
        }

        /// <summary>
        /// Return the singleton
        /// </summary>
        static public ExplosionManager Instance
        {
            get
            {
                if (_instance == null)
                    _instance = new ExplosionManager();

                return _instance;
            }
        }

        /// <summary>
        /// Initialise the explosion manager
        /// </summary>
        /// <param name="bulletCount">Number of bullet to handle</param>
        /// <returns>Return true.</returns>
        public bool init(int bulletCount)
        {
            //create the blank bullet and store references
            _iExplosionCount = bulletCount;
            for (int i = 0; i < _iExplosionCount; i++)
            {
                _listExplosionEntity.Add(World.World.Instance.createBlankExplosion());
            }
            return true;
        }

        public void clear()
        {
            _listExplosionEntity.Clear();
        }

        /// <summary>
        /// Activate a bullet
        /// </summary>
        /// <param name="idAnimation">animation id</param>
        /// <param name="position">world position</param>
        /// <returns>Return true if an explosion was activated or false if the manager couldn't activate any.</returns>
        public bool activate(int idAnimation, Vector2 position)
        {
            for (int i = 0; i < _listExplosionEntity.Count; i++)
            {
                if (!_listExplosionEntity[i].Active)
                {
                    _listExplosionEntity[i].activate(idAnimation, position);
                    return true;
                }
            }

            return false;
        }
    }
}
